<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html>
<head>
    <meta http-equiv="Content-Language" content="fa">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>زرین پال | تست درگاه | تست IP</title>
    <style type="text/css">
        body {
            background: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAHpCAMAAABwXnbdAAAAt1BMVEXu7u7v7+/w8PDx8fHy8vLz8/P09PT19fX29vb39/f4+Pj5+fn6+vr71VD7+/v8zE38zU38zk38zk78z0780E/80U/80k/80lD800/801D81FD81U381U781VD81k781k/81lD8/Pz9x0r9yEr9yUv9ykv9y0v9y0z9zEz9z0790E790kn90kr900r900v91Ev91Ez91U39/f3+xEj+xUj+xUn+xkn+x0n+0Uj+0Un+0kn+/v7///+nn8ExAAABAUlEQVQ4je3I546CUBCG4aNSFLGAggpYwIJ0KdL0/q9r40mcOHtMNpvsr41v8mS+DKnrmnzXNA1p2xYEQQDCMARRFCFxHDOSJAGXy+WtNE0R0zQZlmUxNpsN3O12+2u73Y563a/W6zX1up9GoxHzezAM40er1QpZLpeUrutksVjQ+6Bp2lvz+Zz4vg88zyOz2YxSVZVSFIUxnU6RyWRCzuczcF2XOp1O1PF4ZBwOB2S/3zMcxyFVVZGyLJHr9QqKogB5noP7/f4nbrcbI8syhm3byHg8BrIsI8PhEEiShAwGA9Dv94EoikAQBITnecBxHNLr9ZBut4t0Oh3Gp0+f/l1fYlVb2B6+bYsAAAAASUVORK5CYII=') #eee repeat-x top;
            font-family: Tahoma;
            font-size: 11px;
            direction: rtl;
            margin: 0;
            padding: 0;
        }

        fieldset {
            float: right;
            width: 240px;
            border: 1px solid #ddd;
            font: 12px Tahoma;
            background: #fff;
            padding: 20px;
            margin: 50px 10px 0 0;
            text-align: center;
            height: 165px;
            -moz-border-radius: 5px;
            -webkit-border-radius: 5px 5px 5px 5px;
            border-radius: 5px 5px 5px 5px;
            margin-bottom: 10px;
        }

        fieldset legend {
            background-color: #ccc;
            font-weight: 900;
            margin-right: 14px;
            padding: 5px 30px;
        }

        input.submit {
            background: none repeat scroll 0 0 #FACE61;
            border: 1px solid #D6AB28;
            border-radius: 5px 5px 5px 5px;
            box-shadow: -1px 1px 2px rgba(0, 0, 0, .3);
            color: #2D2D2D;
            font-weight: 900;
            padding: 7px 25px;
        }

        input, button, textarea, select {
            border-radius: 3px;
            padding: 8px;
            background-color: #FFF;
            border: 1px solid #DBE1E8;
        }

        input, button, textarea, select {
            background-color: #EFEFEF;
            border: 1px solid silver;
            font: 11px tahoma;
            vertical-align: middle;
            margin: 0 0 0 2px;
            padding: 3px;
            line-height: 14px;
        }

        #flashMessage, #authMessage {
            min-height: 24px;
            _height: 24px;
            -moz-border-radius: 5px;
            -webkit-border-radius: 5px;
            border-radius: 5px;
            direction: rtl;
            margin: 10px 0;
            padding: 5px 30px 10px 10px;
            text-align: justify;
            clear: both;
            margin: 0 auto;
            width: 825px;
        }

        div.error-msg, div.message {
            border: 1px solid #fe9090;
            background: #feb1b1 url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAjFJREFUeNqkU0tPE1EUPvPoOHdaSSkUsYkY2xLTmpCQmJBAumBNZIFLoz+CX8Av6MpfoHHLhgXsTTWE7ohtDRhEkrGpQy0M7e3ceXnO2Db1BQtv8s3cx/m+87pXCsMQ/meo9HktSaDgnyABZBAbOF1GzA3sviDeoatthOnjgvAcnau/CT6JMbaZXVjIZ+bnU2xiQqcI+eXlonl0VDo5PHwqOC+j3c4vEQzJLJncWlpbK4SqyhzPA+fiYnhmzBYKRjqbnaru7m51f+5HIhJ5eCVJmVu6/mZ5fX2Juy4LguCv+UqYqhqG/GBvb184zrMXYWhGEWA+G3PFYv67bTPHca4tWiwWYzO5XP60VqM6vYwEPICV2+l0ymq3R4au60Kv240ghAAPU4pyVlWYnpxMEWdc4F4gyzoZlSoVME0TOp0OKIoC8XgcEokEaJoWCezkctDv9XTijIpI2h56FLYNjUYj8oah/kGmwajdaOuNd8EFOLNbrcXQsozG6uq1NUiQvRB94oxHUGk1myt3VNUwUP2mccZ5mzg0lwcC25/Pzz+BLHMDW2VQ4/8BbDFvOs4xcUYC2HWz6/vl95ZVxwPOUIQN8h2HQHL16qreC4IycUYXiS7IfVw8xtv4QJY3C5qWf6hpqaSi6GTU8f3+RyHadSGOT5BcxWac4n7EHQhQLaYQ0xmA2SJAaQbgET6uu4OL9rUF8KEG8Bbd4hS+ISzkekMBeSxN9YYa0kPsInrIDX4IMADJaAE/Me2jPAAAAABJRU5ErkJggg==') no-repeat scroll 99% 5px;
            color: #820101;
        }

        .centered {
            position: fixed;
            top: 50%;
            left: 50%;
            margin-left: -100px;
        }

        .message {
            clear: both;
            text-align: center;
            direction: rtl;
            margin-top: 30px;
            font: bold 14px tahoma;
            color: #090;
        }

        .error {
            clear: both;
            text-align: center;
            direction: rtl;
            margin-top: 30px;
            font: bold 14px tahoma;
            color: #c00;
            width: 190px;
            height: 26px;
        }

        .Content {
            width: 890px;
            margin: 0 auto;
        }
    </style>
</head>
<body>
<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo '<div class="Content">
	<fieldset>
		<legend>1.  ماژولهای مورد نياز</legend>';
echo '<div style="margin-top:10px; direction:rtl">آيا ماژولهای زير در PHP شما نصب هستند؟</div>';
echo '<div style="margin-top:10px; direction:ltr"> soap : ' . ((extension_loaded('soap')) ? '<span style="color:#090"> نصب است</span>' : '<span style="color:#c00"> نصب نيست</span>') . '</div>';
echo '<div style="margin-top:10px; direction:ltr"> openssl : ' . ((extension_loaded('openssl')) ? '<span style="color:#090"> نصب است</span>' : '<span style="color:#c00"> نصب نيست</span>') . '</div>';
echo '<div style="margin-top:10px; direction:rtl">PHP Version :  ' . @phpversion(); echo '</div>';
if( @phpversion() < 5.4){
    echo '</br> <div   class="error-msg"> نسخه PHP شما قدیمی است ، لطفا از پشتیبانی هاست خود بخواهید تا نسخه  PHP سرور شما را حداقل به 5.4 ارتقا دهد </div>';
}
echo '</fieldset>';

echo '<fieldset>
		<legend>2. تست IP</legend>';
echo '<div style="margin:10px 0; direction:rtl">بررسی آدرس IP</div>';

if (extension_loaded('curl')) {
    echo '<div style="margin-top:10px; direction:ltr"> curl : <span style="color:#090"> ';
    $ch = curl_init('https://www.zarinpal.com/labs/TestIP');
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_exec($ch);
    if (curl_error($ch)) {
        echo curl_error($ch);
    }
    curl_close($ch);
    echo '</span></div>';
} else {
    echo '<div class="error">خطا در فراخوانی curl.</div>';
}

if (function_exists('fsockopen')) {
    echo '<div style="margin-top:10px; direction:ltr"> fsockopen : <span style="color:#090"> ';
    $url = parse_url('https://www.zarinpal.com/labs/TestIP');
    $content = '';
    $fp = fsockopen('tls://' . $url['host'], 443, $err_num, $err_msg, 30) or die('Socket-open failed--error: ' . $err_num . ' ' . $err_msg);

    fwrite($fp, "GET $url[path] HTTP/1.1\r\n");
    fwrite($fp, "Host: www.zarinpal.com\r\n");
    fwrite($fp, "Connection: close\n\n");

    while (!feof($fp)) {
        $content .= fgets($fp, 128);
    }
    fclose($fp);
    preg_match('/(\d+)\.(\d+)\.(\d+)\.(\d+)/', $content, $matches);
    echo $matches[0];
    echo '</span></div>';
} else {
    echo '<div class="error">خطا در فراخوانی fsockopen.</div>';
}

if (function_exists('file_get_contents')) {
    echo '<div style="margin-top:10px; direction:ltr"> file_get_contents : <span style="color:#090"> ';
    $content = file_get_contents('https://www.zarinpal.com/labs/TestIP');
    preg_match('/(\d+)\.(\d+)\.(\d+)\.(\d+)/', $content, $matches);
    echo $matches[0];
    echo '</span></div>';
} else {
    echo '<div class="error">خطا در فراخوانی file_get_contents.</div>';
}

echo '</fieldset>';
?>
<fieldset>
    <legend>3. تست انجام تراکنش</legend>
    <form name="form1" method="POST">
        <div style="text-align:center; font-size: 14px ; direction:rtl">
            مرچنت کد دریافتی از زرین پال:
            </br></br>
            <input type="text" placeholder="11111111-1111-1111-1111-111111111111" required maxlength="36" name="mid"
                   class="input-eng" style="width:220px;!important;direction:ltr;">
            </br></br>
            مبلغ تراکنش (به تومان):
            </br></br>
            <input type="text" value="2000" name="price" class="input-eng"
                   style="width:120px;!important;direction:ltr;">

            <input type="submit" name="PayRequestSubmit" value="پرداخت" class="submit"/>
    </form>
</fieldset>
<?php

if (isset($_POST['PayRequestSubmit'])) {
    $MerchantID = $_POST['mid']; //Required
    $Amount = $_POST['price']; //Amount will be based on Toman  - Required
    $Description = 'توضیحات تراکنش تستی'; // Required
    $Email = 'UserEmail@Mail.Com'; // Optional
    $Mobile = '09123456789'; // Optional
    $CallbackURL = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF']; // Required

    try {
        $client = @new SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', array('encoding' => 'UTF-8'));
        $result = $client->PaymentRequest(
            array(
                'MerchantID' => $MerchantID,
                'Amount' => $Amount,
                'Description' => $Description,
                'Email' => $Email,
                'Mobile' => $Mobile,
                'CallbackURL' => $CallbackURL,
            ));
        //Redirect to URL You can do it also by creating a form
        switch ($result->Status) {
            case -1:
                $ERR = 'اطلاعات ارسال شده ناقص می باشد';
                break;
            case -2:
                $ERR = 'ادرس IP و یا مرچنت کد به صورت صحیح وارد نشده';
                break;
            case -3:
                $ERR = 'حداقل مبلغ قابل پرداخت 100 تومان می باشد';
                break;
            case -4:
                $ERR = 'سطح تایید پذیرنده پایین تر از سطح نقره ای است';
                break;
            default:
                $ERR = 'کد خطا : ' . $result->Status;
        }
        if ($result->Status == 100) {
            echo '<script type="text/javascript">window.location = "https://www.zarinpal.com/pg/StartPay/' . $result->Authority . '";</script>';
        } else {
            echo '<div id="flashMessage" class="error-msg"> کد خطا  : ' . $result->Status . '<br>علت خطا : ' . $ERR . '</div>';
        }
    } catch (SoapFault $e) {
        echo '<div class="error">خطا در فراخوانی وب‌سرويس.</div>';
    }
}
?>
</div>
</body>
</html>
